/************************************************************************
 * NAME:	fs-cmp.c
 *
 * DESCR:	Implements the CPM file system on top of the floppy struct.
 *
 *
 * NOTES:	
 ************************************************************************/
#include <ctype.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <fcntl.h>
#include "getopt.h"

#include "standard.h"
#include "floppy.h"
#include "fs-cpm.h"
#include "fs-utility.h"


/************************************************************************
 * NAME:	fs_cpm_init() and fs_cpm_cleanup()
 *
 * DESCR:	Initializes/cleans-up the cpm file system structures.
 *
 * ARGS:	
 *
 * RETURNS:	
 *
 * NOTES:	
 ************************************************************************/
int
fs_cpm_init(struct floppy *floppy, struct fs_cpm *fs)
{
    int	ok;
    extern int floppy_read_sector(struct floppy *, int, int, int, char *);
    extern int floppy_write_sector(struct floppy *, int, int, int, char *);

    fs->floppy = floppy;

    if (!cpm_init(&fs->cpmfs, floppy, floppy_read_sector, floppy_write_sector)) {
	return(FALSE);
    }

    return(cpm_settings(&fs->cpmfs,
			2048,		/* size of CPM block	*/
			floppy->tracks,	/* number of tracks	*/
			128,		/* maxdir entry (should this be 128???)		*/
			256,		/* length of sector	*/
			floppy->sectors,/* sectors per track	*/
			2,		/* sector skew		*/
			2,		/* number of boot tracks*/
			1,		/* phy sect starts at 1	*/
			5));		/* up to five open files*/

}

int
fs_cpm_cleanup(struct fs_cpm *fs)
{
    return(cpm_cleanup(&fs->cpmfs));
}

/************************************************************************
 * NAME:	fs_cpm_report()
 *
 * DESCR:	Generates a report on the filesystem structure.
 *
 * ARGS:	
 *
 * RETURNS:	
 *
 * NOTES:	
 ************************************************************************/
int
fs_cpm_report(struct fs_cpm *fs, int verbosity)
{
    cpm_dispdir(&fs->cpmfs);
    return(TRUE);
}

/************************************************************************
 * NAME:	fs_cpm_add()
 *
 * DESCR:	Adds the referenced file to the CPM image.
 *
 * ARGS:	
 *
 * RETURNS:	
 *
 * NOTES:	
 ************************************************************************/
int
fs_cpm_add(struct fs_cpm *fs, char *name, int fd)
{
    char	*cpm_name = fs_basename(name);

    cpm_copyin(&fs->cpmfs,name,cpm_name,TRUE);

    return(TRUE);
}

/************************************************************************
 * NAME:	fs_cpm_del()
 *
 * DESCR:	Deletes the named file from the filesystem.
 *
 * ARGS:	
 *
 * RETURNS:	
 *
 * NOTES:	
 ************************************************************************/
int
fs_cpm_del(struct fs_cpm *fs, char *name)
{
    return(cpm_delete(&fs->cpmfs,name));
}

/************************************************************************
 * NAME:	fs_cpm_extract()
 *
 * DESCR:	Extracts the named file from the filesystem, sending it
 *		out on the given fd.
 *
 * ARGS:	
 *
 * RETURNS:	
 *
 * NOTES:	
 ************************************************************************/
int
fs_cpm_extract(struct fs_cpm *fs, char *name, int fd)
{
    char	*cpm_name = fs_basename(name);

    cpm_copyout(&fs->cpmfs,cpm_name,name,TRUE);

    return(TRUE);
}

/************************************************************************
 * NAME:	fs_cpm_description()
 *
 * DESCR:	Returns the description of this type of file system.
 *
 * ARGS:	
 *
 * RETURNS:	
 *
 * NOTES:	
 ************************************************************************/
char *
fs_cpm_description(void)
{
    return("TRS-80 CP/M");
}


/************************************************************************
 * NAME:	fs_cpm_compress()
 *
 * DESCR:
 *
 * ARGS:	
 *
 * RETURNS:	
 *
 * NOTES:
 ************************************************************************/
int
fs_cpm_compress(struct fs_cpm *fs)
{
}
